<?php
/**
 * Created by Kev.
 * User: Acer
 * Date: 11/4/2018
 * Time: 11:19 AM
 */
require __DIR__ . '/../statcodes/ApiConstants.php';


class AppOps

{

    private $dns = 'mysql:host=localhost;dbname=m_pay';
    private $user = 'root';
    private $pass = 'wolfhouse';
    private $conn;
    private $filePre;
    private $date;
    private $datetime;
    private $stkresponse;

    private $connec = "";

    /**
     * AppOps constructor.
     */
    public function __construct()
    {
        $this->filePre = "uploads/";
        $this->date = date('Y-m-d H:i:s');
        try {

            $this->conn =
                new PDO($this->dns, $this->user, $this->pass);

            //  $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
            $this->conn->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, false);

            if (!$this->conn) {
                $this->connec = SERVER_CONNECT_ERROR;
                echo "connection to server error!";
                die("Connection err");


            } else {
                $this->connec = SERVER_CONNECT_SUCCESS;
                return $this->conn;

                //  echo "Connection to db Success ";
            }
        } catch (PDOException $e) {
            $p = $e->getMessage();
            $this->connec = SERVER_CONNECT_ERROR;

            //echo $p."eeerrr ";
        }

        // $this->datetime = date("Y-m-d H:i:s", strtotime('+2 hours'));
        //=====time for token expiry ===
        $now = new DateTime(); //current date/time
        $now->setTimezone(new DateTimeZone('Africa/Nairobi'));
        $time = 20;
        $now->add(new DateInterval("PT{$time}M"));
        $this->datetime = $now->format('Y-m-d H:i:s A');
    }


    public function getServerStatus()
    {
        return $this->connec;
    }

    public function getConnection()
    {
        return $this->conn;
    }


    public function getUserId($user_phone)
    {
        try {
            $queryy = "SELECT id FROM users_tbl WHERE  phone=?";
            $stmtt = $this->conn->prepare($queryy);
            $stmtt->execute([$user_phone]);
            if ($rows = $stmtt->fetchColumn()) {
                return $rows;
            } else {
                return "not found";
            }
        } catch (PDOException $e) {
            $e->getMessage();
            //   return 0;
            return "not found";

        }

    }

    public function getUserWallet($user_phone)
    {
        try {
            $queryy = "SELECT wallet_balance FROM users WHERE  phonenumber=?";
            $stmtt = $this->conn->prepare($queryy);
            $stmtt->execute([$user_phone]);
            if ($rows = $stmtt->fetch(PDO::FETCH_ASSOC)) {
                return $rows['wallet_balance'];
            } else {
                return "not found";
            }
        } catch (PDOException $e) {
            $e->getMessage();
            //   return 0;
            return "not found";

        }

    }

    public function saveUser(User $user)
    {
        $pass = $this->createPassword($user->getPassword());
        try {
            $query = "INSERT INTO users_tbl (fname,lname, pin,phone,joined_on) VALUES (?,?,?,?,?)";
            $stmt = $this->conn->prepare($query);
            if ($rowa = $stmt->execute([
                $user->getFname(),
                $user->getLname(),
                $pass,
                $user->getPhone(),
                $this->date])) {

                return $this->myResponse(USER_CREATED, "Success", "");
            } else {
                return $this->myResponse(FAILURE, "An error occurred. Phone No. or Username may be already registered", "");

            }
        } catch (PDOException $e) {
            $p = $e->getMessage();
            //  return "An error occurred. Phone No. may be already registered";
            return $this->myResponse(FAILURE, "An error occurred. Phone No. or Username may be already registered", "");

        }
    }

    private function createPassword($password)
    {
        $pas = password_hash($password, PASSWORD_DEFAULT);
        return $pas;
    }

    function myResponse($status, $message, $data)
    {
        $result = array();
        if ($data == "") {
            array_push($result, array(
                    "status" => $status,
                    "message" => $message,
                )
            );
        } else {
            array_push($result, array(
                    "status" => $status,
                    "message" => $message,
                    "data" => $data
                )
            );
        }
        return $result;
    }

    public function delUserInDb($user_phone)
    {
        try {
            $queryy = "DELETE FROM users WHERE  phonenumber=?";
            $stmtt = $this->conn->prepare($queryy);
            $resp = $stmtt->execute([$user_phone]);
            return $resp;
        } catch (PDOException $e) {
            $e->getMessage();

        }

    }


    public function checkUserByID($user_id)
    {
        try {
            $queryy = "SELECT id_number FROM users WHERE  id_number=?";
            $stmtt = $this->conn->prepare($queryy);
            $stmtt->execute([$user_id]);
            if ($rows = $stmtt->fetchColumn()) {
                return USER_EXISTS;
            } else {
                return USER_NOT_FOUND;
            }
        } catch (PDOException $e) {
            $e->getMessage();
            return USER_NOT_FOUND;
        }

    }

    public function savePreferedMode($mode, $phone)
    {
        $sqPrefMode = "UPDATE `users` SET `pref_mode`='" . $mode . "' where `phonenumber`='" . $phone . "'";

        if ($this->conn->query($sqPrefMode)) {

            // $linked = 1;
            //  $sqPrefModeHas="UPDATE `users` SET `has_linked_vip`='".$linked."' where `phonenumber`='".$phone."'";
            /*
                        if($this->conn->query($sqPrefModeHas)){


                        }    */
            return "Done";

        } else {
            return "Something went wrong";
        }


    }

    public function savePreferedModeVIP($mode, $phoneNumber)
    {
        $sqPrefMode = "UPDATE `users` SET `pref_mode`='" . $mode . "' where `phonenumber`='" . $phoneNumber . "'";

        if ($this->conn->query($sqPrefMode)) {

            /* $linked = 1;
               $sqPrefModeHas="UPDATE `users` SET `has_linked_vip`='".$linked."' , `linked_vip_acc`='".$acc_no."',`linked_vip_sec_code`='".$sec_code."',`linked_vip_reg_date`='".$exp_date."' where `phonenumber`='".$phoneNumber."'";

                         if($this->conn->query($sqPrefModeHas)){*/

            return "Done";

            //   }

        } else {
            return "Something went wrong";
        }

    }

    public function savePreferedModeVIPTwo($mode, $phoneNumber, $sec_code, $exp_date, $acc_no)
    {
        $sqPrefMode = "UPDATE `users` SET `pref_mode`='" . $mode . "' where `phonenumber`='" . $phoneNumber . "'";

        if ($this->conn->query($sqPrefMode)) {

            $linked = 1;
            $sqPrefModeHas = "UPDATE `users` SET `has_linked_vip`='" . $linked . "' , `linked_vip_acc`='" . $acc_no . "',`linked_vip_sec_code`='" . $sec_code . "',`linked_vip_reg_date`='" . $exp_date . "' where `phonenumber`='" . $phoneNumber . "'";

            if ($this->conn->query($sqPrefModeHas)) {

                return "Done";

            }

        } else {
            return "Something went wrong";
        }

    }

    public function payFromWallet($send_amount, $send_addr, $user_phone)
    {

        try {
            $queryy = "SELECT wallet_balance FROM users WHERE  phonenumber=?";
            $stmtt = $this->conn->prepare($queryy);
            $stmtt->execute([$user_phone]);
            if ($col = $stmtt->fetch(PDO::FETCH_ASSOC)) {


                $rows = $col['wallet_balance'];

                //return $rows;
                if ($rows < $send_amount) {
                    return "Insufficient";
                } else {

                    $balanceAfter = $rows - $send_amount;

                    $queryy = "UPDATE  users SET wallet_balance = '" . $balanceAfter . "' WHERE phonenumber=?";
                    $stmtr = $this->conn->prepare($queryy);
                    $stmtr->execute([$user_phone]);


                    $query = "INSERT INTO transactions (user_phone,amount, mode,payment_addr,timestamp) VALUES (?,?,?,?,?)";
                    $stmt = $this->conn->prepare($query);
                    if ($rowa = $stmt->execute([
                        $user_phone,
                        $send_amount,
                        "WALLET",
                        $send_addr,
                        $this->date])) {

                        return "Done";
                    } else {
                        return "Error";

                    }
                }

            } else {
                return "error";
            }


        } catch (PDOException $e) {
            $p = $e->getMessage();
            //  return "An error occurred. Phone No. may be already registered";
            return "Error";


        }

    }

    public function payFromVip($send_amount, $send_addr, $user_phone)
    {
        try {
            $queryy = "SELECT vip_acc_balance FROM users WHERE  phonenumber=?";
            $stmtt = $this->conn->prepare($queryy);
            $stmtt->execute([$user_phone]);
            if ($col = $stmtt->fetch(PDO::FETCH_ASSOC)) {


                $rows = $col['vip_acc_balance'];
                if ($rows < $send_amount) {
                    return "Insufficient";
                } else {

                    $balanceAfter = $rows - $send_amount;

                    $queryy = "UPDATE  users SET vip_acc_balance = '" . $balanceAfter . "' WHERE phonenumber=?";
                    $stmtr = $this->conn->prepare($queryy);
                    $stmtr->execute([$user_phone]);


                    $query = "INSERT INTO transactions (user_phone,amount, mode,payment_addr,timestamp) VALUES (?,?,?,?,?)";
                    $stmt = $this->conn->prepare($query);
                    if ($rowa = $stmt->execute([
                        $user_phone,
                        $send_amount,
                        "VIP",
                        $send_addr,
                        $this->date])) {

                        return "Done";
                    } else {
                        return "Error";

                    }
                }

            } else {
                return "error";
            }


        } catch (PDOException $e) {
            $p = $e->getMessage();
            //  return "An error occurred. Phone No. may be already registered";
            return "Error";


        }
    }

    public function getIfSetPref($user_phone)
    {

        try {
            $queryy = "SELECT pref_mode FROM users WHERE  phonenumber=?";
            $stm = $this->conn->prepare($queryy);
            $stm->execute([$user_phone]);
            if ($rows = $stm->fetchColumn()) {
                return $rows;
            } else {
                return "error";
            }

        } catch (PDOException $e) {
            $p = $e->getMessage();

            return "Error";


        }

    }

    public function getIfLinkedVIP($user_phone)
    {

        try {
            $queryy = "SELECT has_linked_vip FROM users WHERE  phonenumber=?";
            $stmtt = $this->conn->prepare($queryy);
            $stmtt->execute([$user_phone]);
            if ($col = $stmtt->fetch(PDO::FETCH_ASSOC)) {


                $rows = $col['has_linked_vip'];
                if ($rows == 1) {
                    return "Done";
                } else {
                    return "Yet";
                }

            } else {
                return "Yet";
            }


        } catch (PDOException $e) {
            $p = $e->getMessage();
            //  return "An error occurred. Phone No. may be already registered";
            return "Error";


        }
    }

    public function getHomeMenu($names)
    {

        $response = "CON Hello, " . $names . "\n";
        $response .= " 1:Send money.\n";
        $response .= " 2:Link VIP Account\n";
        $response .= " 3:Check wallet balance\n";
        $response .= " 4:Set payment preference\n";
        return $response;
    }

    public function getAllUsers()
    {
        $stmt =
            $this->conn->query("SELECT `fname`,`lname`,`id`,`phone`,`joined_on` FROM users_tbl");
        $users = array();
        while ($roww = $stmt->fetch(PDO::FETCH_ASSOC)) {
            array_push($users, array(
                "fname" => $roww['fname'],
                "lname" => $roww['lname'],
                "id" => $roww['id'],
                "phone" => $roww['phone'],
                "joined_on" => $roww['joined_on']
            ));

        }


        return $this->myResponse(SUCCESS, "Success", $users);
    }

    private function getPassword($password, $hashed)
    {
        $pas = password_verify($password, $hashed);
        if ($pas) {
            return true;
        } else {
            return false;
        }
    }


}
